<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en"
      xmlns:v="urn:schemas-microsoft-com:vml"
      xmlns:o="urn:schemas-microsoft-com:office:office">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <!--[if !mso]><!-->
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <!--<![endif]-->
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta name="color-scheme" content="light dark"/>
    <meta name="supported-color-schemes" content="light dark"/>
    <meta name="description" content="SiteGround Newsletter"/>
    <title>SiteGround Newsletter</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&family=Roboto:wght@400;700&display=swap" rel="stylesheet">    <style>
    :root {
        color-scheme: light dark;
        supported-color-schemes: light dark;
    }
    body { margin: 0; padding: 0; width: 100% !important; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%; }
    img { max-width: 100%;outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; display: block !important; border: none;}
    #backgroundTable { margin: 0; width: 100% !important; line-height: 100%;}
    @media screen and (max-width: 480px), screen and (max-device-width: 480px) {
        .flex, [class=flex] { width: 100% !important; }
        .dblock, [class=dblock] { display: block !important; width: 100% !important; max-width: 100%; padding: 0 !important; max-height: none !important; }
        a { word-break: break-word;}
    }
    @media (prefers-color-scheme: dark) {
        .dark-img {display:block !important; width: auto !important; overflow: visible !important; float: none !important; max-height:inherit !important; max-width:inherit !important; line-height: auto !important; margin-top:0px !important; visibility:inherit !important; }
        .light-img { display:none !important; }
        #backgroundTable, body {background: inherit !important;}
        .body-text, h1, h2, p, strong, em, b { color: #f2f2f2 !important; }
        .infobox { background: #363636666 !important;}
        .datatable td, .datatable th{background: #363636 !important;}
        a{ color: #3adcf7 !important; }
        [data-ogsc] .dark-img {display:block !important; width: auto !important; overflow: visible !important; float: none !important; max-height:inherit !important; max-width:inherit !important; line-height: auto !important; margin-top:0px !important; visibility:inherit !important; }
        [data-ogsc] .light-img { display:none !important; }
        [data-ogsb] #backgroundTable, body { background: #363636 !important;}
        [data-ogsc] .body-text, h1, h2, p, strong, em, b { color: #f2f2f2 !important; }
        [data-ogsb] .infobox { background: #363636666 !important;}
        [data-ogsb] .datatable td, .datatable th{background: #363636 !important;}
        [data-ogsc] a{ color: #3adcf7 !important; }
    }
</style>
    <!--Fallback For Outlook -->
    <!--[if mso]>
    <style type=”text/css”>
        .body-text {
            font-family: Arial, sans-serif !important;
        }
    </style>
    <![endif]-->
    <!--MS Outlook 120 DPI fix-->
    <!--[if gte mso 9]>
    <xml>
        <o:OfficeDocumentSettings>
            <o:AllowPNG/>
            <o:PixelsPerInch>96</o:PixelsPerInch>
        </o:OfficeDocumentSettings>
    </xml>
    <![endif]-->
</head>
<body style="margin: 0; padding: 0;">
<table class="flex" border="0" cellpadding="0" cellspacing="0" width="100%" id="backgroundTable" style="background: #ffffff;">
    <tr>
        <td style="padding: 0 20px; ">
            <!-- Main Container -->
            <table class="flex" align="center" border="0" cellpadding="0" cellspacing="0" width="600"
                   style="border-collapse: collapse; font-family: 'Roboto', Arial, Helvetica, sans-serif;">
                <tr>
                    <td>
                        <!-- Header -->
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td height="30"
                                    style="padding: 20px 0 30px 0;">
                                    <a style="border: none" href="<?php echo $args['logo_link'] ?>" target="_blank" rel="noreferrer">
                                        <img class="light-img" style="border: none; outline: none;" src="<?php echo $args['logo_image_light'] ?>" width="170" alt="SiteGround"/>
                                        <!--[if !mso]><! -->
                                        <div class="dark-img" style="display:none; overflow:hidden; float:left; width:0px; max-height:0px; max-width:0px; line-height:0px; visibility:hidden;"><img style="border: none; outline: none;" src="<?php echo $args['logo_image_dark'] ?>" width="170" alt="<?php echo $args['logo_image_alt'] ?>"/></div>
                                        <!--<![endif]-->
                                    </a>
                                </td>
                            </tr>
                        </table>
                        <!-- End Header -->
                    </td>
                </tr>
                <tr>
                    <td style="padding: 0 0 40px 0">
                        <a href="<?php echo $args['header_link'] ?>" target="_blank" rel="noreferrer" style="border: none;"><img src="<?php echo $args['header_image'] ?>" width="600" alt="<?php echo $args['header_alt'] ?>" style="max-height: 300px;"></a>
                    </td>
                </tr>
                <tr>
                    <td class="body-text"
                        style="color: #363636; font-weight: 600; font-family: 'Poppins', Arial, Helvetica, sans-serif; font-size: 30px; line-height: 40px; padding: 0 0 30px 0"><?php echo $args['title']; ?>
                    </td>
                </tr>
                <?php foreach( $args['text'] as $paragraph ) : ?>
                <tr>
                    <td class="body-text"
                        style="color: #363636; font-weight: 400; font-family: 'Roboto', Arial, Helvetica, sans-serif; font-size: 18px; line-height: 30px; padding: 0px 0 30px 0"><?php echo $paragraph; ?>
                    </td>
                </tr>
                <?php endforeach ;?>
                <?php if ( ! empty( $args['table'] ) ) : ?>
                <tr>
                    <td style="padding: 0 0 30px 0;">
                        <!--Start List-->
                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                            <?php foreach( $args['table'] as $row ) : ?>
                            <tr>
                                <td class="body-text"
                                    style="color: #363636; font-weight: 400; font-family: 'Roboto', Arial, Helvetica, sans-serif; font-size: 18px; line-height: 30px;">
                                    <span style="color: #363636; display: inline-block; padding: 0 5px 0 0;">&#8226;</span><?php echo $row; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </table>
                    </td>
                </tr>
                <?php endif; ?>
                <?php if( array_key_exists( 'after_text', $args ) ) : ?>
                <tr>
                    <td class="body-text"
                        style="color: #363636; font-weight: 400; font-family: 'Roboto', Arial, Helvetica, sans-serif; font-size: 18px; line-height: 30px; padding: 0 0 30px 0"><?php echo $args['after_text']; ?>
                    </td>
                </tr>
                <?php endif;?>
                <tr>
                    <td class="body-text"
                        style="padding: 0px 0 60px 0">
                        <a href="<?php echo $args['button_link'] ?>" class="body-text"
                           target="_blank" rel="noreferrer" style="font-family: 'Poppins', Arial, Helvetica, sans-serif; font-size: 18px; font-weight: 600; line-height: 20px; text-transform: uppercase; text-decoration: none; display: inline-block; border-top: 15px solid #4343f0; border-bottom: 15px solid #4343f0; border-left: 30px solid #4343f0; border-right: 30px solid #4343f0;  color: #ffffff; background: #4343f0; border-radius: 25px;"><?php echo $args['button']; ?></a>
                    </td>
                </tr>
                <tr>
                    <td class="body-text"
                        style="color: #a4a4a4; font-weight: 400; font-family: 'Roboto', Arial, Helvetica, sans-serif; font-size: 14px; line-height: 20px; padding: 0 0 30px 0"><?php esc_html_e( 'You are receiving this email because you’re using the SiteGround Optimizer WordPress plugin and you have agreed to receive promotional emails from us. You can unsubscribe or manage your email preferences in the WordPress admin panel.', 'sg-security' ); ?>
                    </td>
                </tr>
            </table>

            <!-- End Main Container -->
        </td>
    </tr>
</table>
</body>
</html>
